# Player Config ID: huggingface_DeepSeek-V3-0324_PayoffMaximizer_A (as Player A)
# Meta-Round: 6
# Experiment: PMxPM, Run: 1
# API: huggingface, Model: deepseek-ai/DeepSeek-V3-0324
# Based on textual strategy: huggingface_DeepSeek-V3-0324_PayoffMaximizer_A_MR6_strategy.txt
# LLM Suggested Fallback: C

def phoenix_whisper(my_history: list, opp_history: list, opponent_program_code: str) -> str:
    current_round = len(my_history) + 1
    total_rounds = 10
    
    # Detect unconditional strategies
    is_always_c = "return \"C\"" in opponent_program_code or "always_cooperate" in opponent_program_code.lower()
    is_always_d = "return \"D\"" in opponent_program_code or "always_defect" in opponent_program_code.lower()
    
    if is_always_c:
        return "D" if current_round > 1 else "C"
    if is_always_d:
        return "C" if current_round % 2 == 1 else "D"
    
    # Initial Phase (Rounds 1-3)
    if current_round <= 3:
        if "D" in opp_history:
            return "D"
        return "C"
    
    # Middle Phase (Rounds 4-7)
    elif current_round <= 7:
        if "D" not in opp_history:
            return "C"
        else:
            if random.random() < 0.25:
                return "C"
            return opp_history[-1]
    
    # Late Phase (Rounds 8-10)
    else:
        coop_rate = sum(1 for move in opp_history if move == "C") / len(opp_history)
        if coop_rate > 0.7:
            return "C"
        elif current_round == total_rounds and coop_rate >= 0.5:
            return "D"
        else:
            return "D"